<?php

use App\Http\Controllers\DimController;
use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/
Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

Route::post('register', 'UserController@register');
Route::post('login', 'UserController@login');
Route::get('open', 'DataController@open');

Route::group(['middleware' => ['jwt.verify', 'api']], function () {
    Route::get('user', 'UserController@getAuthenticatedUser');
    Route::get('akademis', 'DimController@getDataAkademis');
    Route::get('orangtua', 'DimController@getDataOrangtua');
    Route::get('sekolah','DimController@getDataAsalSekolah');
    Route::get('dim', 'DimController@getDataPribadi');
    Route::put('updateDim','DimController@updateDataPribadi');
    Route::put('updateOrangtua','DimController@updateDataOrangtua');
    Route::put('updateDataSekolah','DimController@updateDataSekolah');
    Route::get('closed', 'DataController@closed');
    Route::get('dataAsrama','KeasramaanController@getDataAsrama');
    Route::get('nilaiAsrama','KeasramaanController@getNilaiKeasramaan');
    Route::post('izinBermalam/{id}', 'IzinBermalamController@requestIzin');
    Route::get('izinBermalam/{id}', 'IzinBermalamController@getIzinBermalam');
    Route::get('getIzin/{id}/{izinId}', 'IzinBermalamController@getDetailIzinBermalam');
    Route::get('logout','UserController@logout');
    Route::get('nilaiAsrama/{idUser}','KeasramaanController@getNilaiKeasramaan');
    Route::get('pengumuman','TambahanController@getPengumuman');
    Route::get('pengumuman/{pengumumanId}','TambahanController@getDetailPengumuman');
    Route::get('detailNilaiAsrama/{idPenilaian}','KeasramaanController@getDetailNilaiKeasramaan');
    Route::get('paket','TambahanController@getPaket');
    Route::get('paket/{idPaket}','TambahanController@getDetailPaket');
    Route::put('editIb/{izinId}/{id}','IzinBermalamController@editIzinBermalam');
    Route::get('kuesionerWajib','KuesionerController@getKuesionerWajib');
    Route::put('batalIb','IzinBermalamController@cancelIzinBermalam');
    Route::get('izinKeluar/{dimId}','IzinKeluarController@getIzinKeluar');
    Route::get('izinKeluar/{id}/{izinId}','IzinKeluarController@getDetailIzinKeluar');
    Route::post('izinKeluar/{dimId}','IzinKeluarController@buatIzinKeluar');
    Route::put('izinKeluar/{izinId}/{id}','IzinKeluarController@editIzinKeluar');
    Route::put('izinKeluar','IzinKeluarController@cancelIzinKeluar');
    Route::get('jadwal','JadwalController@getAllJadwal');
    Route::get('jadwalToday','JadwalController@getJadwalToday');
});
Route::get('kurikulum/{tahun}/{prodi}','PerkuliahanController@filterMatkulByTahunAndProdi');
Route::get('perkuliahan/{idPerkuliahan}','PerkuliahanController@getMateriKuliah');
Route::get('filePraktikum/{praktikumId}','PerkuliahanController@getFilePraktikumKuliah');
Route::get('praktikum/{idPerkuliahan}','PerkuliahanController@getPraktikumKuliah');
Route::get('fileMateri/{materiId}','PerkuliahanController@getFileMateriKuliah');
Route::get('admin/getAll','IzinBermalamController@getAllIzinBermalam');
// Route::get('kuesioner','KuesionerController@createKuesioner');
Route::get('kuesioner','KuesionerController@getKuesioner');
Route::post('isiKuesioner','KuesionerController@sendKuesioner');
Route::get('pertanyaan/{idKuesioner}','KuesionerController@getPertanyaanKuesioner');
Route::post('approveIB/{idIzin}','IzinBermalamController@approveOrNotIzinBermalam');
